<?php
/*
Plugin Name: Paragrapher
Plugin URI: http://cmarshall.com/misc/paragrapher.zip
Description: Very simple plugin that massages content to allow you to use proper paragraph style. Specify a style for "p.first" and "p" to use the results. All carriage returns and linefeeds are converted to paragraphs, and all <p> tags are replaced. My suggestion for styles is p { text-indent:1em } and p.first { text-indent:0 }
Author: Chris Marshall
Version: 1.0
Author URI: http://cmarshall.net/
*/ 

function paragrapher ( $the_content )
	{
	$the_content = preg_replace ( "|</p>\s*<p[^>]*>|", "\n", $the_content );
	$the_content = preg_replace ( "|<p[^>]*>|", "", $the_content );
	$the_content = str_replace ( "\n", "</p>\n<p>", $the_content );
	$the_content = str_replace ( "\r", "</p>\n<p>", $the_content );
	$the_content = "<p class=\"first\">$the_content</p>";
	return $the_content;
	}

add_filter ( 'the_content', paragrapher );
?>